import math
import csv

def loss(true,pred):
    return (pred-true)**2

def loss_derivative(true, pred):
    return (pred-true)

def activation_derivative(x):
    return 1/math.cosh(x)**2

def activation(x):
    return math.tanh(x)

def train(crust, tomato, cheese, fingers, true, lr):
    global w1, w2, w3, w4
    crust_z = ((crust) * w1)
    tomato_z = ((tomato) * w2)
    cheese_z = ((cheese) * w3)
    fingers_z = ((fingers) * w4)

    score = activation(crust_z + tomato_z + cheese_z + fingers_z)

    print("Loss:", loss(int(true), score)) #best to be nearer to 0!

    #calculates the derivatives
    error1 = loss_derivative(int(true), activation(crust_z)) * activation_derivative(crust_z)
    error2 = loss_derivative(int(true), activation(tomato_z)) * activation_derivative(tomato_z)
    error3 = loss_derivative(int(true), activation(cheese_z)) * activation_derivative(cheese_z)
    error4 = loss_derivative(int(true), activation(fingers_z)) * activation_derivative(fingers_z)

    update1 = error1 * crust
    update2 = error2 * tomato
    update3 = error3 * cheese
    update4 = error4 * fingers

    w1 -= lr * update1
    w2 -= lr * update2
    w3 -= lr * update3
    w4 -= lr * update4


#TRAIN YOUR MODEL!

# 1) Initialise weights all as 0.1
# These will be changed during backprop but the closer you can get them to start with the better!

w1 = 0.1
w2 = 0.1
w3 = 0.1
w4 = 0.1

#ignore this - importing training data
examples = []
with open('training.csv','r') as csvFile:
    csvReader = csv.reader(csvFile)
    next(csvReader)
    for row in csvReader:
        examples.append(row)
    csvFile.close()

# 2) Set the number of training epochs
# This is the number of times we run our backprop - the more the better.
epochs = 2

# 3) Set the learning rate
# This is the amount of change made during each iteration
learning_rate = 0.01

#running training loops!
for x in range(epochs):
    for example in examples:
        train(float(example[0])/10, float(example[1])/10, float(example[2])/10, float(example[3])/10, float(example[4]), learning_rate)

print(w1, w2, w3, w4)
print("")

# Other ideas: change the training data in the excel file, extension: change the learning rate over time.

# training finished


#TEST YOUR MODEL!
#Try some inputs from -1 to 1 and see if the model thinks you will like pizza
crust = -0.3
tomato = -0.1
cheese = 0.9
fingers = -0.5

crust_z = crust * w1
tomato_z = tomato * w2
cheese_z = cheese * w3
fingers_z = fingers * w4

score = crust_z + tomato_z + cheese_z + fingers_z

activation = activation(score)

print(activation)

if activation >= 0:
  print("I think you would like pizza")
else:
  print("Maybe you won't like pizza")
